//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.4

Image {
    id : image

    property color color : "black"

    layer.enabled     : true
    layer.samplerName : "icon"
    layer.effect      : ShaderEffect {
        property color color : image.color

        fragmentShader : "
            uniform lowp float     qt_Opacity;
            uniform lowp sampler2D icon;
            uniform lowp vec4      color;

            varying lowp vec2 qt_TexCoord0;

            void main() {
                lowp vec4 tex = texture2D(icon, qt_TexCoord0);
                gl_FragColor = color * tex.a * qt_Opacity;
            }
        "
    }
}

